﻿<!DOCTYPE html>
<html>
<meta http-equiv="Content-Type"  content="text/html charset=UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<head>
	<title>Mide tu huella</title>
<!-- jQuery Core 2.2.4  -->
<script src="js/jquery-2.2.4.min.js"></script>

<!-- Latest compiled and minified CSS -->
<link rel="stylesheet" href="css/bootstrap.min.css">

<!-- Latest compiled and minified JavaScript -->
<script src="js/bootstrap.min.js"></script>	

<!-- Custom style-->
<link rel="stylesheet" href="css/style.css" />

<!-- Flags stuff -->
<link rel="stylesheet" type="text/css" href="css/style2.css">
<script src="js/fx.js"></script>


<style>
html, body {
    height: 100%;
}

body{
        background-color: white;
        background-image: url('img/fondo.jpg');
        background-size: auto 100%;
        background-repeat: no-repeat;
        background-position: center top;
}

#mide{
    margin-top: 6.5vh;
    margin-left: -10vh;
    font-size: 1.7vh;
}

#titulo-seccion-1, #titulo-seccion-2{
    margin-left: 11vh;
    font-size: 4vh;
}

#casa{
     margin-top: -2vh;
     height: 7vh;
}

input[type="text"]
{
    background: transparent;
    font-weight: bold;
    text-align: center;

}
input[type="number"]
{
    background: transparent;
    font-weight: bold;
    text-align: center;

}
select
{
    background: transparent;
    background-color: #5FA53F;
    font-weight: bold;

}

.new-boton{
    height: 5vh;
    width: 25vh;
    background-color: #5FA53F;
    font-weight: bold;
    line-height: 5vh;
    margin: 0 auto;
    border-radius: 1vh;
    margin-top: 1vh;

}

.new-boton:hover {
    background-color: #EF9126;
    cursor: pointer; 
    cursor: hand;

}
a:hover {
    text-decoration: none;
}

#preguntas{
    margin-top: 15vh;
}

.btn-new{
    background-color: #95C223;
}

#vivienda{
    height: 60vh;
}

</style>
</head>
<?php
$edad = $_POST['edad'];
$region = $_POST['region'];
$correo = $_POST['correo'];

switch ($region) {
    case 'I':    $tregion = "Tarapacá"; break;
    case 'II':   $tregion = "Antofagasta"; break;
    case 'III':  $tregion = "Atacama"; break;
    case 'IV':   $tregion = "Coquimbo"; break;
    case 'V':    $tregion = "Valparaiso"; break;
    case 'RM':   $tregion = "Metropolitana"; break;
    case 'VI':  $tregion = "O'Higgins"; break;
    case 'VII': $tregion = "Maule"; break;
    case 'VIII':   $tregion = "Biobío"; break;
    case 'IX':    $tregion = "La Araucanía"; break;
    case 'X':   $tregion = "Los Lagos"; break;
    case 'XI':  $tregion = "Aisén"; break;
    case 'XII': $tregion = "Magallanes"; break;
    case 'XIV':  $tregion = "Los Ríos"; break;
    case 'XV':   $tregion = "Arica y Parinacota"; break;
    default:  $tregion = "" ; break;
}
?>
<body class="block-center">
<div class="text-center" id="mide"><b>MIDE TU HUELLA</b> / JOVEN / <?php echo $tregion; ?></div>

<div id="vivienda">
    <div class="text-center" id="titulo-seccion-1">
        <b>VIVIENDA</b>
        <img id="casa" src="img/casa.png" />
    </div>   
    <div class="text-center" id="preguntas">
        <h4>¿Cuántas personas <br>viven en tu hogar?</h4>
    </div>
    <div class="text-center inline-block">
        <div style="display: inline-block"><input type="number" name="habitantes" id="habitantes" value="1"  min="1" max="50" style="width: 100px;"></div>
            <button class="btn btn-new" id="resta">-</button>
            <button class="btn btn-new" id="suma">+</button>

    </div>
    <div class="text-center" id="vivienda-volver" style="margin-top:100px">
        <a href="index2.html">
            <div class="new-boton">
                VOLVER
            </div>
        </a>
    </div>
    <div class="text-center"  id="vivienda-boton">
            <div class="new-boton">
                SIGUIENTE
            </div>
    </div>    
</div><!-- fin div vivienda -->

<div id="transporte">
    <div class="text-center" id="titulo-seccion-2">
        <b>TRANSPORTE</b>
        <!-- <img id="vehiculo" src="//s3.amazonaws.com/midetuhuella-static/images/xx.png" /> -->        
    </div>   
    <div class="text-center" id="preguntas-2a">
        <h4>¿Cuánto dinero gastas en bencina <br>al mes? (En pesos)</h4>
    </div>
    <div class="text-center inline-block">
        <div style="display: inline-block"><input type="text" name="bencina" id="bencina" value="0" width="4"></div>
             <button class="btn btn-new" id="restabencina">-</button>
             <button class="btn btn-new" id="sumabencina">+</button>
    </div>

    <div class="text-center" id="preguntas-2b">
        <h4>¿Cuánto dinero gastas en petróleo<br> al mes? (En pesos)</h4>
    </div>
    <div class="text-center inline-block">
        <div style="display: inline-block"><input type="text" name="diesel" id="diesel" value="0" width="4"></div>
             <button class="btn btn-new" id="restadiesel">-</button>
             <button class="btn btn-new" id="sumadiesel">+</button>
    </div>
    
    <div class="text-center" id="preguntas-2c">
        <h4>¿Cuántos kilómetros recorres <br>en micro al día?</h4>
    </div>
    <div class="text-center inline-block">
        <div style="display: inline-block"><input type="text" name="micro" id="micro" value="0" width="4"></div>
             <button class="btn btn-new" id="restamicro">-</button>
             <button class="btn btn-new" id="sumamicro">+</button>
    </div>

    <div class="text-center" id="preguntas-2d">
<?php
switch ($region) {
    case 'V':
        echo "  <h4>¿Cuántas estaciones de Merval <br>recorres al día?</h4>";
        break;
    case 'RM':
        echo "  <h4>¿Cuántas estaciones de Metro <br>recorres al día?</h4>";
        break;
    case 'VIII':
        echo "  <h4>¿Cuántas estaciones de Biotren <br>recorres al día?</h4>";
        break;
}
?>
    </div>
    <div class="text-center inline-block" id="respuestas-2d">
        <div style="display: inline-block"><input type="text" name="metro" id="metro" value="0" width="4"></div>
             <button class="btn btn-new" id="restametro">-</button>
             <button class="btn btn-new" id="sumametro">+</button>
    </div>

    <div class="text-center" id="transporte-volver">
        <div class="new-boton">
            VOLVER
        </div>
    </div>

    <div class="text-center" id="transporte-boton">
        <div class="new-boton">
            SIGUIENTE
        </div>
    </div>

</div><!-- fin transporte -->

<div id="reciclaje">
    <div class="text-center" id="titulo-seccion-1">
        <b>RECICLAJE</b>
        <!-- <img id="casa" src="//s3.amazonaws.com/midetuhuella-static/images/casa.png" /> -->
    </div>   
    <div class="text-center" id="preguntas">
        <h4>¿Cuánto reciclas <br>en tu hogar?</h4>
    </div>
    <div class="campo text-center center-block">
            <select name="reciclar" id="reciclar">
                <option value="0.07">Todo</option>
                <option value="0.12">Algo</option>
                <option value="0.16">Nada</option>
            </select>
    </div>
    <div class="text-center" id="reciclaje-volver" style="margin-top: 5vh;">
        <div class="new-boton">
            VOLVER
        </div>
    </div>    
    <div class="text-center" id="reciclaje-boton">
        <div class="new-boton">
            SIGUIENTE
        </div>
    </div>    
</div><!-- fin div reciclaje -->

<div id="energia">
    <div class="text-center" id="titulo-seccion-2">
        <b>ENERGÍA</b>
        <!-- <img id="vehiculo" src="//s3.amazonaws.com/midetuhuella-static/images/xx.png" /> -->
    </div>   
    <div class="text-center" id="preguntas-2a">
        <h4>¿Cuánto se gasta al mes en luz <br>en tu hogar? (En pesos)</h4>
    </div>
    <div class="text-center inline-block">
        <div style="display: inline-block"><input type="text" name="luz" id="luz" value="0" width="4"></div>
             <button class="btn btn-new" id="restaluz">-</button>
             <button class="btn btn-new" id="sumaluz">+</button>
    </div>

    <div class="text-center" id="energia-volver" style="margin-top: 5vh;">
        <div class="new-boton">
            VOLVER
        </div>
    </div>      

    <div class="text-center" id="energia-boton">
        <div class="new-boton">
            SIGUIENTE
        </div>
    </div>

</div><!-- fin energia -->


<div id="calefaccion">
    <div class="text-center" id="titulo-seccion-1">
        <b>CALEFACCIÓN</b>
        <!-- <img id="casa" src="//s3.amazonaws.com/midetuhuella-static/images/casa.png" /> -->
    </div>   
    <div class="text-center" id="preguntas">
        <h4>¿Tienes calefacción <br>en tu hogar?</h4>
    </div>
    <div class="campo text-center center-block">
        <input type="radio" name="tienecalefaccion" value="1"> SI
        <input type="radio" name="tienecalefaccion" value="0"> NO
    </div>
    <div class="text-center" id="divcombustible" style="font-size: 19px;">
        ¿Qué combustible usan para calefaccionar?<br>
        <select id="tipoCombustible">
                <option id="combustible" value="1">Gas Natural</option>
                <option id="combustible" value="2">Gas Licuado</option>
                <option id="combustible" value="3">Parafina</option>
                <option id="combustible" value="5">Petróleo</option>
                <option id="combustible" value="6">Leña</option>
        </select>
          
        <!-- Acotar esta pregunta -->
        <div class="text-center inline-block" id="divdinerocalefaccion">
        ¿Cuánto dinero gastas al mes en calefacción? <br>(En pesos)<br>
            <div style="display: inline-block">
                <input type="text" name="dinerocalefaccion" id="dinerocalefaccion" value="0" width="4"></div>
                <button class="btn btn-new" id="restadinerocalefaccion">-</button>
                <button class="btn btn-new" id="sumadinerocalefaccion">+</button>
        </div> 

         <div class="text-center inline-block" id="divmetroscalefaccion">
        ¿Cuántos mt<sup>2</sup> mide tu hogar aprox.? <br>
            <div style="display: inline-block">
                <input type="text" name="metroscalefaccion" id="metroscalefaccion" value="0" width="4"></div>
                <button class="btn btn-new" id="restametroscalefaccion">-</button>
                <button class="btn btn-new" id="sumametroscalefaccion">+</button>
        </div>          

    </div>

    <div class="text-center" id="calefaccion-volver" style="margin-top: 2vh;">
        <div class="new-boton">
            VOLVER
        </div>
    </div>
    
    <div class="text-center" id="calefaccion-boton">
        <div class="new-boton">
            SIGUIENTE
        </div>
    </div>  
</div><!-- fin div calefaccion -->

<div id="alimentacion">
    <div class="text-center" id="titulo-seccion-1">
        <b>ALIMENTACIÓN</b>
        <!-- <img id="casa" src="//s3.amazonaws.com/midetuhuella-static/images/casa.png" /> -->
    </div>   
    <div class="text-center" id="preguntas">
        <h4>¿Cúal es tu tipo de alimentación</h4>
    </div>
    <div class="campo text-center center-block">
            <select name="alimentar" id="alimentar">
                <option value="0.74">Vegano</option>
                <option value="1.18">Vegetariano</option>
                <option value="1.62">Carnívoro</option>
            </select>
    </div>

    <div class="text-center" id="alimentacion-volver">
        <div class="new-boton">
            VOLVER
        </div>
    </div> 

    <div class="text-center" id="alimentacion-boton">
        <div class="new-boton">
            FINALIZAR
        </div>
    </div>    
</div><!-- fin div alimentacion -->

<!-- Modal -->
<div id="myModal" class="modal fade" role="dialog">
  <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content">

      <div class="modal-body">

    <table border="0" align="center">
        <thead></thead>
        <tbody>
            <tr> <!-- 1 -->
                <td rowspan="12">
                <img src="images/Panel-28.png" style="max-height: 900px;margin-top: -60px;"></td>
                <td class="flag"><img class="flag" src="images/Panel-02.png"><div class="subt">Costa Rica</div></td>
                <td class="flag"><img class="flag" src="images/Panel-14.png"></td>
                <td class="flag"><img class="flag" src="images/Panel-15.png"></td>
                <td class="flag"><img class="flag" src="images/Panel-14.png"></td>
                <td class="flag numero"><img class="flag" src="images/Panel-27.png"></td>
            </tr>
            <tr>
                <!-- 2 -->
                <td><img class="flag" src="images/Panel-03.png"><div class="subt" id="Uruguay">Uruguay</div></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag" src="images/Panel-15.png"></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag numero" src="images/Panel-26.png"></td>
            </tr>
            <tr>
                <!-- 3 -->
                <td><img class="flag" src="images/Panel-04.png"><div class="subt">Colombia</div></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag" src="images/Panel-15.png"></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag numero" src="images/Panel-16.png"></td>
            </tr>
            <tr>
                <!-- 4 -->
                <td><img class="flag" src="images/Panel-05.png"><div class="subt">Chile</div></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag" src="images/Panel-15.png"></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag numero" src="images/Panel-17.png"></td>
            </tr>
            <tr>
                <!-- 5 -->
                <td><img class="flag" src="images/Panel-06.png"><div class="subt">Per&uacute;</div></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag" src="images/Panel-15.png"></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag numero" src="images/Panel-18.png"></td>
            </tr>
            <tr>
                <!-- 6 -->
                <td><img class="flag" src="images/Panel-07.png"><div class="subt">Suiza</div></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag" src="images/Panel-15.png"></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag numero" src="images/Panel-19.png"></td>
            </tr>
            <tr>
                <!-- 7 -->
                <td><img class="flag" src="images/Panel-08.png"><div class="subt">China</div></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag" src="images/Panel-15.png"></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag numero" src="images/Panel-20.png"></td>
            </tr>
            <tr>
                <!-- 8 -->
                <td><img class="flag" src="images/Panel-09.png"><div id="UE" class="subt">Uni&oacute;n Europea</div></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag" src="images/Panel-15.png"></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag numero" src="images/Panel-21.png"></td>
            </tr>
            <tr>
                <!-- 9 -->
                <td><img class="flag" src="images/Panel-10.png"><div class="subt">Brasil</div></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag" src="images/Panel-15.png"></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag numero" src="images/Panel-22.png"></td>
            </tr>
            <tr>
                <!-- 10 -->
                <td><img class="flag" src="images/Panel-11.png"><div class="subt">Argentina</div></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag" src="images/Panel-15.png"></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag numero" src="images/Panel-23.png"></td>
            </tr>

            <tr>
                <!-- 11 -->
                <td><img class="flag" src="images/Panel-12.png"><div class="subt">Nueva Zelanda</div></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag" src="images/Panel-15.png"></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag numero" src="images/Panel-24.png"></td>
            </tr>

            <tr>
                <!-- 12 -->
                <td><img class="flag" src="images/Panel-13.png"><div class="subt">Estados Unidos</div></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag" src="images/Panel-15.png"></td>
                <td><img class="flag" src="images/Panel-14.png"></td>
                <td><img class="flag numero" src="images/Panel-25.png"></td>
            </tr>
            
            <tr>
                <td class="arrow"><span id="huella"> 4.6 </span><img class="flag" src="images/panel2-02.png"></td>
            </tr>
        </tbody>
    </table>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
      </div>
    </div>

  </div>
</div>
<!-- Fin Modal -->  

<div id="resultados">
    <div class="text-center" id="titulo-seccion-1">
        <b>RESULTADOS</b>
        <!-- <img id="casa" src="//s3.amazonaws.com/midetuhuella-static/images/casa.png" /> -->
    </div>   
    <div class="text-center" id="preguntas">
        <h4>Tu emisión anual de <br>CO<sub>2</sub> es:</h4>
    </div>
    <div class="campo text-center center-block">
           <h3><span id="huellatotal"> XX </span> Toneladas</h3>
    </div>
    <div class="text-center" id="resultados-boton" style="margin-top: 15vh;">
        <div class="new-boton">
            COMPARAR
        </div>
    </div>    
</div><!-- fin div resultados -->


<div id="comparar">
    <div class="text-center" id="titulo-seccion-1">
        <b>COMPARATIVA</b>
        <!-- <img id="casa" src="//s3.amazonaws.com/midetuhuella-static/images/casa.png" /> -->
    </div>   
    <div class="text-center" id="preguntas" style="margin-top: 10vh;">
        <h4>Tu emisión anual de <br>CO<sub>2</sub> equivale a:</h4>
    </div>
    <div class="campo text-center center-block">
           <h4> <span id="diastransantiago">XX,YY</span> días de funcionamiento<br/> de un Transantiago</h4>
           <img src="img/bus.png" style="width: 30vh;">
    </div>
    <div class="campo text-center center-block" style="margin-top:3vh";>
           <h4> Una capa de <span id="aniosampolleta">32,24</span> cms<br />sobre la cancha del Estadio Nacional</h4>
           <img src="img/cancha.png" style="width: 360px;">
    </div>

    <div class="text-center" id="comparar-boton">
        <a href="index2.html">
        <div class="new-boton" style="width: 20vh;">   
            Volver a Medir
        </div>
        </a>
    </div>    
</div><!-- fin div resultados -->
</body>



<script type="text/javascript"> 
$(document).ready(function() {
    document.body.style.overflow = 'hidden';
    $('#edad').focus();

$('#tipoCombustible').change(function() {
    if( $(this).val() == 6 ) 
    {
        $('#divdinerocalefaccion').hide();
        $('#divmetroscalefaccion').show();
    }
    else
    {
        $('#divdinerocalefaccion').show();
        $('#divmetroscalefaccion').hide();        
    }
});    

    //Ocultar los que no son el primero
    $("#transporte").toggle();
    $("#reciclaje").toggle();
    $("#energia").toggle();
    $("#calefaccion").toggle();
    $("#alimentacion").toggle();    
    $("#resultados").toggle();    
    $("#comparar").toggle();    


    $("#preguntas-2d").hide();
    $("#respuestas-2d").hide();

<?php
        if($region == "RM" || $region == "V" || $region == "VIII")
                {
                echo "$(\"#preguntas-2d\").toggle();";
                echo "$(\"#respuestas-2d\").toggle();";
                }
?>


    $("#vivienda-boton").click(function(event){
        event.preventDefault();
        $("#vivienda").toggle();
        $("#vivienda-boton").toggle();
        $("#transporte").toggle();
    });

    $("#transporte-volver").click(function(event){
        event.preventDefault();
        $("#vivienda").toggle();
        $("#vivienda-boton").toggle();
        $("#transporte").toggle();
    });

    $("#transporte-boton").click(function(event){
        event.preventDefault();
        $("#transporte").toggle();
        $("#reciclaje").toggle();        
    });

    $("#reciclaje-volver").click(function(event){
        event.preventDefault();
        $("#transporte").toggle();
        $("#reciclaje").toggle();        
    });

    $("#reciclaje-boton").click(function(event){
        event.preventDefault();
        $("#reciclaje").toggle();
        $("#energia").toggle();       
    });    

    $("#energia-volver").click(function(event){
        event.preventDefault();
        $("#reciclaje").toggle();
        $("#energia").toggle();       
    });  

    $("#energia-boton").click(function(event){
        event.preventDefault();
        $("#energia").toggle();       
        $("#calefaccion").toggle();
    }); 

    $("#calefaccion-volver").click(function(event){
        event.preventDefault();
        $("#energia").toggle();       
        $("#calefaccion").toggle();
    }); 

    $("#calefaccion-boton").click(function(event){
        event.preventDefault();
        $("#calefaccion").toggle();       
        $("#alimentacion").toggle();       
    });   

    $("#alimentacion-volver").click(function(event){
        event.preventDefault();
        $("#calefaccion").toggle();       
        $("#alimentacion").toggle();       
    });  

    $("#alimentacion-boton").click(function(event){
        event.preventDefault();
        $("#alimentacion").toggle();       
        $("#resultados").toggle();       
        calcular();
    });        

    $("#resultados-boton").click(function(event){
        event.preventDefault();
        $("#resultados").toggle();       
        $("#comparar").toggle();       
    });   

  $("#divcombustible").hide();

 $(":radio").change(function () {
            $("#divcombustible").toggle();
        });

  var $radios = $('input:radio[name=tienecalefaccion]');
  if($radios.is(':checked') === false) {
     $radios.filter('[value=0]').prop('checked', true);
     }

    //Calculos
      $("#suma").click(function(event){
             event.preventDefault();
             $("#habitantes").val(parseInt($("#habitantes").val())+1);
            });

        $("#resta").click(function(event){
             event.preventDefault();
             if ($("#habitantes").val()>1) {
                $("#habitantes").val(parseInt($("#habitantes").val())-1);
                }
        });

      $("#sumamicro").click(function(event){
             event.preventDefault();
             $("#micro").val(parseInt($("#micro").val())+1);
            });

        $("#restamicro").click(function(event){
             event.preventDefault();
             if ($("#micro").val()>0) {
                $("#micro").val(parseInt($("#micro").val())-1);
                }
        });
      
      $("#sumabencina").click(function(event){
             event.preventDefault();
             $("#bencina").val(parseInt($("#bencina").val())+1000);
            });

        $("#restabencina").click(function(event){
             event.preventDefault();
             if ($("#bencina").val()>0) {
                $("#bencina").val(parseInt($("#bencina").val())-1000);
                }
        });
      
      $("#sumadiesel").click(function(event){
             event.preventDefault();
             $("#diesel").val(parseInt($("#diesel").val())+1000);
            });

        $("#restadiesel").click(function(event){
             event.preventDefault();
             if ($("#diesel").val()>0) {
                $("#diesel").val(parseInt($("#diesel").val())-1000);
                }
        });

      $("#sumametro").click(function(event){
             event.preventDefault();
             $("#metro").val(parseInt($("#metro").val())+1);
            });

        $("#restametro").click(function(event){
             event.preventDefault();
             if ($("#metro").val()>0) {
                $("#metro").val(parseInt($("#metro").val())-1);
                }
        });

      $("#sumaluz").click(function(event){
             event.preventDefault();
             $("#luz").val(parseInt($("#luz").val())+1000);
            });

        $("#restaluz").click(function(event){
             event.preventDefault();
             if ($("#luz").val()>0) {
                $("#luz").val(parseInt($("#luz").val())-1000);
                }
        });        


      $("#sumadinerocalefaccion").click(function(event){
             event.preventDefault();
             $("#dinerocalefaccion").val(parseInt($("#dinerocalefaccion").val())+1000);
            });

        $("#restadinerocalefaccion").click(function(event){
             event.preventDefault();
             if ($("#dinerocalefaccion").val()>1) {
                $("#dinerocalefaccion").val(parseInt($("#dinerocalefaccion").val())-1000);
                }
        });

      $("#sumametroscalefaccion").click(function(event){
             event.preventDefault();
             $("#metroscalefaccion").val(parseInt($("#metroscalefaccion").val())+10);
            });

      $("#restametroscalefaccion").click(function(event){
             event.preventDefault();
             if ($("#metroscalefaccion").val()>1) {
                $("#metroscalefaccion").val(parseInt($("#metroscalefaccion").val())-10);
                }
        });          
    });

function calcular(){
    
    //inicial
    ///var nombre =     $('#nombre').val();
    ///var email =      $('#email').val();
    var habitantes = $('#habitantes').val();

    //transporte
    var bencina = $('#bencina').val() * 0.002240 / 700;  //dinero dividido en valor litro por factor
    var diesel  = $('#diesel').val()  * 0.002676 / 500;  
    var micro   = $('#micro').val()   * 0.0000346 * 20;  // km diarios * factor * 20 dias al mes
    var metro   = $('#metro').val()   * 0.0000204 * 20;    
 
    //alert(micro+' - '+bencina+' - '+metro+' - '+diesel);
    var transporte = micro+bencina+metro+diesel;
    //alert(transporte);
    //reciclaje
    var reciclaje = $("#reciclar").val();

    //energia
    var luz = $('#luz').val(); // valor en pesos
    luz = parseFloat(luz);
    var electricidad = ((luz / 112.360) * 0.000346); //sur de taltal (monto mensual CLP dividido por valor KWH * factor emision )

    //alert(electricidad);
    //calefaccion

    var calefa = 0;

/*
    1 - Gas Natural     : 1,970 Kg CO2/Nm3      0,32 m3/h (3000 kcal/h)
    2 - Gas Licuado     : 2,985 Kg CO2/Nm3      0,30 Kg/h
    3 - Parafina        : 2,580 Kg CO2/kg       0,25 Lt/h
    4 - Electricidad    : 0,391 Kg CO2/KWH      2,00 KW/h
    5 - Petróleo        : 2,670 Kg CO2/Lt       2,00 Lt/h 
    6 - Leña            : 0 //leña es carbono neutral :S
*/    

    var horas  = $('#dias').val();
    var dincal = $('#dinerocalefaccion').val();
    var mtcal  = $('#metroscalefaccion').val();

    var tipoComb = document.getElementById("tipoCombustible").value;     

    if (tipoComb == 1) { calefa =  dincal /  750 * 0.001970 / 2; } //dinero que gasta dividido en valor por unidad por factor en 6 mese (año/2)
    if (tipoComb == 2) { calefa =  dincal / 1000 * 0.002985 / 2; }
    if (tipoComb == 3) { calefa =  dincal /  500 * 0.002580 / 2; }
    if (tipoComb == 5) { calefa =  dincal /  461 * 0.002670 / 2; }
    if (tipoComb == 6) { calefa =  mtcal  *  0.0174 / 2; }        // leña 0,0174 TonCo2 anual por m2 de hogar 

    calefa=parseFloat(calefa); 

    //estilo
    var estilo = $("#alimentar").val();
    estilo = parseFloat(estilo);    
    reciclaje = parseFloat(reciclaje);    

    //totales   
    var mensual = transporte + (electricidad + calefa)/ habitantes;    
    var anual = (mensual * 12);
    anual = reciclaje + anual + estilo ; //validar unidades de medicion (todo en toneladas / mes)
    
    //formateo a 2 decimales
    //mensual = mensual.toFixed(2);
    mensual = parseFloat(mensual).toFixed(2);
    //anual = anual.toFixed(2);
    anual = parseFloat(anual).toFixed(2);
   
    //completo los campos
    $("#mensual").text(mensual);
    $("#huellatotal").text(anual);
    var diast = parseFloat(anual/0.01915).toFixed(2); 
    tt = diast.replace(".", ",");
    $("#diastransantiago").text(tt);

    var aniosamp = parseFloat(anual*8).toFixed(2); 
    aa = aniosamp.replace(".",",");
    $("#aniosampolleta").text(aa);

    //muestro las banderas con valores
    showCountries(anual);

//inserto en la DB
var phabitantes = $('#habitantes').val();
var pregion     = "<?php echo $tregion; ?>";
var pedad       = 2;
var pmicro      = $('#micro').val(); 
var pauto       = 0;
var pbencina    = $('#bencina').val();  
var pdiesel     = $('#diesel').val();  
var pmetro      = $('#metro').val();
var pbici       = 0; 
var ptransporte = transporte;
var preciclaje  = $("#reciclar").val();
var ptv         = 0;
var ppc         = 0;
var pvjg        = 0;
var penergia    = electricidad;
var phoras      = 0;
var ptipoComb   = tipoComb;
var pcalefa     = calefa;
var pestilo     = estilo;
var pmensual    = mensual;  
var panual      = anual;    
var pcorreo     = '<?php echo $correo; ?>';

$.ajax({
  async:true,    
  cache:false,   
  dataType:"html",
  type: 'POST',   
  url: "graba.php",
  data: 'phabitantes='+phabitantes+
    '&pregion='+pregion+
    '&pedad='+pedad+
    '&pmicro='+pmicro+
    '&pauto='+pauto+
    '&pbencina='+pbencina+
    '&pdiesel='+pdiesel+
    '&pmetro='+pmetro+
    '&pbici='+pbici+
    '&ptransporte='+ptransporte+
    '&preciclaje='+preciclaje+
    '&ptv='+ptv+
    '&ppc='+ppc+
    '&pvjg='+pvjg+
    '&penergia='+penergia+
    '&phoras='+phoras+
    '&ptipoComb='+ptipoComb+
    '&pcalefa='+pcalefa+
    '&pestilo='+pestilo+
    '&pmensual='+pmensual+
    '&panual='+panual+
    '&pcorreo='+pcorreo,
  success:  function(respuesta){   },
  beforeSend:function(){},
  error:function(objXMLHttpRequest){}
});    
}

</script>
</html>
